library(memisc)
load("ESS-relig.RData")

source("utils/complete-csets.R")

foreach(
    wide_data=c(
        ESS_denom,
        ESS_denom_age,
        ESS_relatt,
        ESS_relatt_age,
        ESS_relatt_denom,
        ESS_pray,
        ESS_pray_age,
        ESS_pray_denom,
        ESS_religious,
        ESS_religious_age,
        ESS_religious_denom),
    long_data=c(
        ESS_denom_choice,
        ESS_denom_age_choice,
        ESS_relatt_choice,
        ESS_relatt_age_choice,
        ESS_relatt_denom_choice,
        ESS_pray_choice,
        ESS_pray_age_choice,
        ESS_pray_denom_choice,
        ESS_religious_choice,
        ESS_religious_age_choice,
        ESS_religious_denom_choice),{
long_data <- complete_csets(
    CHES_id~country2+essround,
    data=wide_data,
    weights=wgt)
print(nrow(long_data))
})



save(ESS_denom_choice,
     ESS_denom_age_choice,
     ESS_relatt_choice,
     ESS_relatt_age_choice,
     ESS_relatt_denom_choice,
     ESS_pray_choice,
     ESS_pray_age_choice,
     ESS_pray_denom_choice,
     ESS_religious_choice,
     ESS_religious_age_choice,
     ESS_religious_denom_choice,
     file="ESS-relig-choice.RData")
